/*
 * Decompiled with CFR 0.152.
 */
package controlP5;

import controlP5.CColor;
import controlP5.CDrawable;
import controlP5.ControlP5;
import controlP5.ControlP5IOHandler;
import controlP5.ControlP5XMLElement;
import controlP5.ControlWindowKeyListener;
import controlP5.ControllerList;
import controlP5.PAppletWindow;
import controlP5.Tab;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import processing.core.PApplet;

public class ControlWindow {
    int mouseX;
    int mouseY;
    int pmouseX;
    int pmouseY;
    boolean mousePressed;
    ControlP5 controlP5;
    boolean mouselock;
    public int background = 0;
    CColor color = new CColor();
    private String _myName = "main";
    protected PApplet _myApplet;
    private boolean isPAppletWindow;
    ControllerList _myTabs;
    boolean isVisible = true;
    boolean isInit = false;
    boolean isRemove = false;
    CDrawable _myDrawable;
    protected boolean isPostDraw;
    boolean isUpdate;

    public ControlWindow(ControlP5 controlP5, PApplet pApplet) {
        this.controlP5 = controlP5;
        this._myApplet = pApplet;
        this._myApplet.registerMouseEvent((Object)this);
        this.isPostDraw = true;
        this.init();
    }

    protected void init() {
        this._myTabs = new ControllerList();
        if (this._myApplet instanceof PAppletWindow) {
            this._myName = ((PAppletWindow)this._myApplet).name();
            this.isPAppletWindow = true;
            ((PAppletWindow)this._myApplet).setControlWindow(this);
        }
        if (this.isPAppletWindow) {
            this.background = -16777216;
        }
        if (!this.isInit) {
            if (this._myApplet instanceof PAppletWindow) {
                this._myApplet.registerKeyEvent((Object)new ControlWindowKeyListener(this));
            } else {
                ControlP5.keyHandler.update(this);
            }
        }
        this._myTabs.add(new Tab(this.controlP5, this, "global"));
        this._myTabs.add(new Tab(this.controlP5, this, "default"));
        this.activateTab((Tab)this._myTabs.get(1));
        if (this._myApplet.g.getClass().getName().indexOf("PGraphics2D") > -1 || this._myApplet.g.getClass().getName().indexOf("PGraphics3D") > -1) {
            System.out.println("### INFO you are using renderer " + this._myApplet.g.getClass().getName() + "\n" + "to draw controlP5 you have to call the controlP5.draw() method inside of\n" + "your processing sketch draw() method.");
        } else if (!this.isInit) {
            this._myApplet.registerPre((Object)this);
            this._myApplet.registerPost((Object)this);
        }
        this.isInit = true;
    }

    public Tab currentTab() {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).isActive()) continue;
            return (Tab)this._myTabs.get(i);
        }
        return null;
    }

    public void activateTab(String string) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (!((Tab)this._myTabs.get(i)).name().equals(string)) continue;
            this.activateTab((Tab)this._myTabs.get(i));
        }
    }

    public void removeTab(Tab tab) {
        this._myTabs.remove(tab);
    }

    public Tab add(Tab tab) {
        this._myTabs.add(tab);
        return tab;
    }

    protected void activateTab(Tab tab) {
        for (int i = 1; i < this._myTabs.size(); ++i) {
            if (this._myTabs.get(i) == tab) {
                ((Tab)this._myTabs.get(i)).setActive(true);
                continue;
            }
            ((Tab)this._myTabs.get(i)).setActive(false);
        }
    }

    public ControllerList tabs() {
        return this._myTabs;
    }

    public Tab tab(String string) {
        return this.controlP5.tab(this, string);
    }

    public void remove() {
        for (int i = this._myTabs.size() - 1; i >= 0; --i) {
            ((Tab)this._myTabs.get(i)).remove();
        }
        this._myTabs.clear();
        this._myTabs.clearDrawable();
    }

    public void clear() {
        this.remove();
        if (this._myApplet instanceof PAppletWindow) {
            this._myApplet.stop();
            ((PAppletWindow)this._myApplet).dispose();
            this._myApplet = null;
            System.gc();
        }
    }

    public void updateEvents() {
        this._myTabs.get(0).updateEvents();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).continuousUpdateEvents();
            if (!((Tab)this._myTabs.get(i)).isActive() || !((Tab)this._myTabs.get(i)).isVisible()) continue;
            this._myTabs.get(i).updateEvents();
        }
    }

    public void update() {
        this._myTabs.get(0).update();
        for (int i = 1; i < this._myTabs.size(); ++i) {
            ((Tab)this._myTabs.get(i)).update();
        }
    }

    public void setUpdate(boolean bl) {
        this.isUpdate = bl;
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).setUpdate(bl);
        }
    }

    public boolean isUpdate() {
        return this.isUpdate;
    }

    public void pre() {
        if (this.isVisible && this.isPAppletWindow) {
            this._myApplet.background(this.background);
        }
    }

    public void post() {
        if (this.isPostDraw) {
            this.draw();
        }
    }

    protected void draw() {
        this.updateEvents();
        if (this.isVisible) {
            int n = this._myApplet.g.rectMode;
            int n2 = this._myApplet.g.ellipseMode;
            this._myApplet.rectMode(0);
            this._myApplet.ellipseMode(0);
            if (this._myDrawable != null) {
                this._myDrawable.draw(this._myApplet);
            }
            this._myApplet.noStroke();
            this._myApplet.noFill();
            int n3 = 0;
            int n4 = 0;
            for (int i = 1; i < this._myTabs.size(); ++i) {
                if (!((Tab)this._myTabs.get(i)).isVisible()) continue;
                if (n3 > this.component().getWidth() - ((Tab)this._myTabs.get(i)).width()) {
                    n4 = n3 / (this.component().getWidth() - ((Tab)this._myTabs.get(i)).width()) * 17;
                    n3 = 0;
                }
                ((Tab)this._myTabs.get(i)).setOffset(n3, n4);
                ((Tab)this._myTabs.get(i)).drawLabel(this._myApplet);
                if (((Tab)this._myTabs.get(i)).isActive()) {
                    ((Tab)this._myTabs.get(i)).draw(this._myApplet);
                }
                n3 += ((Tab)this._myTabs.get(i)).width();
            }
            this._myTabs.get(0).draw(this._myApplet);
            this.pmouseX = this.mouseX;
            this.pmouseY = this.mouseY;
            this._myApplet.rectMode(n);
            this._myApplet.ellipseMode(n2);
        }
    }

    public void setContext(CDrawable cDrawable) {
        this._myDrawable = cDrawable;
    }

    public String name() {
        return this._myName;
    }

    public void mouseEvent(MouseEvent mouseEvent) {
        this.mouseX = mouseEvent.getX();
        this.mouseY = mouseEvent.getY();
        if (this.isVisible) {
            int n;
            if (mouseEvent.getID() == 501) {
                this.mousePressed = true;
                for (n = 0; n < this._myTabs.size(); ++n) {
                    if (!this._myTabs.get(n).setMousePressed(true)) continue;
                    this.mouselock = true;
                    if (this.controlP5.DEBUG) {
                        System.out.println("### mouselock = " + this.mouselock);
                    }
                    return;
                }
            }
            if (mouseEvent.getID() == 502) {
                this.mousePressed = false;
                this.mouselock = false;
                for (n = 0; n < this._myTabs.size(); ++n) {
                    this._myTabs.get(n).setMousePressed(false);
                }
            }
        }
    }

    public void keyEvent(KeyEvent keyEvent) {
        for (int i = 0; i < this._myTabs.size(); ++i) {
            this._myTabs.get(i).keyEvent(keyEvent);
        }
    }

    public void setColorActive(int n) {
        this.color.colorActive = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorActive(n);
        }
    }

    public void setColorForeground(int n) {
        this.color.colorForeground = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorForeground(n);
        }
    }

    public void setColorBackground(int n) {
        this.color.colorBackground = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorBackground(n);
        }
    }

    public void setColorLabel(int n) {
        this.color.colorLabel = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorLabel(n);
        }
    }

    public void setColorValue(int n) {
        this.color.colorValue = n;
        for (int i = 0; i < this.tabs().size(); ++i) {
            ((Tab)this.tabs().get(i)).setColorValue(n);
        }
    }

    public void setBackground(int n) {
        this.background = n;
    }

    public PApplet papplet() {
        return this._myApplet;
    }

    public Component component() {
        return this.papplet();
    }

    public void hide() {
        this.isVisible = false;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(false);
        }
    }

    public void show() {
        this.isVisible = true;
        if (this.isPAppletWindow) {
            ((PAppletWindow)this._myApplet).visible(true);
        }
    }

    public boolean isVisible() {
        return this.isVisible;
    }

    protected ControlP5XMLElement getAsXML() {
        ControlP5XMLElement controlP5XMLElement = new ControlP5XMLElement(new Hashtable(), true, false);
        controlP5XMLElement.setName("window");
        controlP5XMLElement.setAttribute("class", this._myApplet.getClass().getName());
        controlP5XMLElement.setAttribute("name", this.name());
        controlP5XMLElement.setAttribute("width", "" + this._myApplet.width);
        controlP5XMLElement.setAttribute("height", "" + this._myApplet.height);
        controlP5XMLElement.setAttribute("background", ControlP5IOHandler.intToString(this.background));
        if (this._myApplet.getClass().getName().indexOf("controlP5.PAppletWindow") != -1) {
            controlP5XMLElement.setAttribute("x", "" + ((PAppletWindow)this._myApplet).x);
            controlP5XMLElement.setAttribute("y", "" + ((PAppletWindow)this._myApplet).y);
        }
        return controlP5XMLElement;
    }
}

